#include <bits/stdc++.h>
using namespace std;

struct Vec {
    long long x, y;
    int id;
};

int quad(const Vec& v) {
    if (v.y > 0 || (v.y == 0 && v.x >= 0)) return 0;
    return 1;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<Vec> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i].x >> a[i].y;
        a[i].id = i+1;
    }
    sort(a.begin(), a.end(), [&](const Vec& A, const Vec& B){
        int q1 = quad(A), q2 = quad(B);
        if (q1 != q2) return q1 < q2;
        return (__int128)A.x*B.y - (__int128)A.y*B.x > 0;
    });

    vector<Vec> w(2*n);
    for (int i = 0; i < n; i++) w[i] = w[n+i] = a[i];
    long long curx = 0, cury = 0;
    long long best = -1;
    int l = 0, bestl = 0, bestr = 0;
    for (int r = 0; r < 2*n; r++) {
        curx += w[r].x;
        cury += w[r].y;

        while (true) {
            long long x1 = w[l].x, y1 = w[l].y;
            long long x2 = w[r].x, y2 = w[r].y;

            long long cross = x1*y2 - y1*x2;
            long long dot = x1*x2 + y1*y2;

            if (!(cross < 0 && dot < 0)) break;

            curx -= w[l].x;
            cury -= w[l].y;
            l++;
        }

        if (r - l + 1 <= n) {
            long long val = curx*curx + cury*cury;
            if (val > best) {
                best = val;
                bestl = l;
                bestr = r;
            }
        }
    }

    vector<int> sol;
    for (int i = bestl; i <= bestr; i++)
        sol.push_back(w[i].id);

    sort(sol.begin(), sol.end());
    sol.erase(unique(sol.begin(), sol.end()), sol.end());

    cout << sol.size() << "\n";
    for (int x : sol) cout << x << " ";
    cout << "\n";

    return 0;
}